# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor metrics alert show",
)
class Show(AAZCommand):
    """Show a metrics-based alert rule.

    :example: Show a metrics-based alert rule.
        az --name MyAlertRule --resource-group MyResourceGroup
    """

    _aaz_info = {
        "version": "2018-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.insights/metricalerts/{}", "2018-03-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the alert rule.",
            required=True,
            id_part="name",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.MetricAlertsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class MetricAlertsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "ruleName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.actions = AAZListType()
            properties.auto_mitigate = AAZBoolType(
                serialized_name="autoMitigate",
            )
            properties.criteria = AAZObjectType(
                flags={"required": True},
            )
            properties.description = AAZStrType()
            properties.enabled = AAZBoolType(
                flags={"required": True},
            )
            properties.evaluation_frequency = AAZStrType(
                serialized_name="evaluationFrequency",
                flags={"required": True},
            )
            properties.is_migrated = AAZBoolType(
                serialized_name="isMigrated",
                flags={"read_only": True},
            )
            properties.last_updated_time = AAZStrType(
                serialized_name="lastUpdatedTime",
                flags={"read_only": True},
            )
            properties.scopes = AAZListType(
                flags={"required": True},
            )
            properties.severity = AAZIntType(
                flags={"required": True},
            )
            properties.target_resource_region = AAZStrType(
                serialized_name="targetResourceRegion",
            )
            properties.target_resource_type = AAZStrType(
                serialized_name="targetResourceType",
            )
            properties.window_size = AAZStrType(
                serialized_name="windowSize",
                flags={"required": True},
            )

            actions = cls._schema_on_200.properties.actions
            actions.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.actions.Element
            _element.action_group_id = AAZStrType(
                serialized_name="actionGroupId",
            )
            _element.web_hook_properties = AAZDictType(
                serialized_name="webHookProperties",
            )

            web_hook_properties = cls._schema_on_200.properties.actions.Element.web_hook_properties
            web_hook_properties.Element = AAZStrType()

            criteria = cls._schema_on_200.properties.criteria
            criteria["odata.type"] = AAZStrType(
                flags={"required": True},
            )

            disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
            disc_microsoft__azure__monitor__multiple_resource_multiple_metric_criteria.all_of = AAZListType(
                serialized_name="allOf",
            )

            all_of = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of
            all_of.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element
            _element.criterion_type = AAZStrType(
                serialized_name="criterionType",
                flags={"required": True},
            )
            _element.dimensions = AAZListType()
            _element.metric_name = AAZStrType(
                serialized_name="metricName",
                flags={"required": True},
            )
            _element.metric_namespace = AAZStrType(
                serialized_name="metricNamespace",
            )
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.skip_metric_validation = AAZBoolType(
                serialized_name="skipMetricValidation",
            )
            _element.time_aggregation = AAZStrType(
                serialized_name="timeAggregation",
                flags={"required": True},
            )

            dimensions = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.dimensions
            dimensions.Element = AAZObjectType()
            _ShowHelper._build_schema_metric_dimension_read(dimensions.Element)

            disc_dynamic_threshold_criterion = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.discriminate_by("criterion_type", "DynamicThresholdCriterion")
            disc_dynamic_threshold_criterion.alert_sensitivity = AAZStrType(
                serialized_name="alertSensitivity",
                flags={"required": True},
            )
            disc_dynamic_threshold_criterion.failing_periods = AAZObjectType(
                serialized_name="failingPeriods",
                flags={"required": True},
            )
            disc_dynamic_threshold_criterion.ignore_data_before = AAZStrType(
                serialized_name="ignoreDataBefore",
            )
            disc_dynamic_threshold_criterion.operator = AAZStrType(
                flags={"required": True},
            )

            failing_periods = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.discriminate_by("criterion_type", "DynamicThresholdCriterion").failing_periods
            failing_periods.min_failing_periods_to_alert = AAZFloatType(
                serialized_name="minFailingPeriodsToAlert",
                flags={"required": True},
            )
            failing_periods.number_of_evaluation_periods = AAZFloatType(
                serialized_name="numberOfEvaluationPeriods",
                flags={"required": True},
            )

            disc_static_threshold_criterion = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").all_of.Element.discriminate_by("criterion_type", "StaticThresholdCriterion")
            disc_static_threshold_criterion.operator = AAZStrType(
                flags={"required": True},
            )
            disc_static_threshold_criterion.threshold = AAZFloatType(
                flags={"required": True},
            )

            disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria")
            disc_microsoft__azure__monitor__single_resource_multiple_metric_criteria.all_of = AAZListType(
                serialized_name="allOf",
            )

            all_of = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").all_of
            all_of.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").all_of.Element
            _element.criterion_type = AAZStrType(
                serialized_name="criterionType",
                flags={"required": True},
            )
            _element.dimensions = AAZListType()
            _element.metric_name = AAZStrType(
                serialized_name="metricName",
                flags={"required": True},
            )
            _element.metric_namespace = AAZStrType(
                serialized_name="metricNamespace",
            )
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.operator = AAZStrType(
                flags={"required": True},
            )
            _element.skip_metric_validation = AAZBoolType(
                serialized_name="skipMetricValidation",
            )
            _element.threshold = AAZFloatType(
                flags={"required": True},
            )
            _element.time_aggregation = AAZStrType(
                serialized_name="timeAggregation",
                flags={"required": True},
            )

            dimensions = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").all_of.Element.dimensions
            dimensions.Element = AAZObjectType()
            _ShowHelper._build_schema_metric_dimension_read(dimensions.Element)

            disc_microsoft__azure__monitor__webtest_location_availability_criteria = cls._schema_on_200.properties.criteria.discriminate_by("odata.type", "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria")
            disc_microsoft__azure__monitor__webtest_location_availability_criteria.component_id = AAZStrType(
                serialized_name="componentId",
                flags={"required": True},
            )
            disc_microsoft__azure__monitor__webtest_location_availability_criteria.failed_location_count = AAZFloatType(
                serialized_name="failedLocationCount",
                flags={"required": True},
            )
            disc_microsoft__azure__monitor__webtest_location_availability_criteria.web_test_id = AAZStrType(
                serialized_name="webTestId",
                flags={"required": True},
            )

            scopes = cls._schema_on_200.properties.scopes
            scopes.Element = AAZStrType()

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""

    _schema_metric_dimension_read = None

    @classmethod
    def _build_schema_metric_dimension_read(cls, _schema):
        if cls._schema_metric_dimension_read is not None:
            _schema.name = cls._schema_metric_dimension_read.name
            _schema.operator = cls._schema_metric_dimension_read.operator
            _schema.values = cls._schema_metric_dimension_read.values
            return

        cls._schema_metric_dimension_read = _schema_metric_dimension_read = AAZObjectType()

        metric_dimension_read = _schema_metric_dimension_read
        metric_dimension_read.name = AAZStrType(
            flags={"required": True},
        )
        metric_dimension_read.operator = AAZStrType(
            flags={"required": True},
        )
        metric_dimension_read.values = AAZListType(
            flags={"required": True},
        )

        values = _schema_metric_dimension_read.values
        values.Element = AAZStrType()

        _schema.name = cls._schema_metric_dimension_read.name
        _schema.operator = cls._schema_metric_dimension_read.operator
        _schema.values = cls._schema_metric_dimension_read.values


__all__ = ["Show"]
