% File src/library/tools/man/rtags.Rd
% Part of the R package, https://www.R-project.org
% Copyright 2008-2015 R Core Team
% Distributed under GPL 2 or later

\name{rtags}
\alias{rtags}
\title{ An \I{Etags}-like Tagging Utility for R }
\description{
  \code{rtags} provides \I{etags}-like indexing capabilities for R code,
  using R's own parser.
}
\usage{
rtags(path = ".", pattern = "\\\\.[RrSs]$",
      recursive = FALSE,
      src = list.files(path = path, pattern = pattern,
                       full.names = TRUE,
                       recursive = recursive),
      keep.re = NULL,
      ofile = "", append = FALSE,
      verbose = getOption("verbose"),
      type = c("etags", "ctags"))
}

\arguments{
  \item{path, pattern, recursive}{
    Arguments passed on to \code{\link{list.files}} to determine the
    files to be tagged.  By default, these are all files with extension
    \file{.R}, \file{.r}, \file{.S}, and \file{.s} in the current
    directory.  These arguments are ignored if \code{src} is specified.
  }
  \item{src}{
    A vector of file names to be indexed.
  }
  \item{keep.re}{ A regular expression further restricting \code{src}
    (the files to be indexed).  For example, specifying
    \code{keep.re = "/R/[^/]*\\\\.R$"} will only retain files with
    extension \file{.R} inside a directory named \file{R}.
  }

  \item{ofile}{ Passed on to \code{\link{cat}} as the \code{file}
    argument; typically the output file where the tags will be written
    (\code{"TAGS"} or \code{"tags"} by convention).  By default, the
    output is written to the R console (unless redirected).
  }
  \item{append}{ Logical, indicating whether the output should overwrite
    an existing file, or append to it.
  }
  \item{verbose}{ Logical.  If \code{TRUE}, file names are echoed to the
    R console as they are processed.
  }
  \item{type}{ Character string specifying whether emacs style
    (\code{"etags"}) or vi style (\code{"ctags"}) tags are to be
    generated.
  }
}

\details{
  Many text editors allow definitions of functions and other language
  objects to be quickly and easily located in source files through a
  tagging utility.  This functionality requires the relevant source
  files to be preprocessed, producing an index (or tag) file containing
  the names and their corresponding locations.  There are multiple tag
  file formats, the most popular being the vi-style \I{ctags} format and the
  and emacs-style \I{etags} format.  Tag files in these formats are usually
  generated by the \code{ctags} and \code{etags} utilities respectively.
  Unfortunately, these programs do not recognize R code syntax.  They do
  allow tagging of arbitrary language files through regular expressions,
  but this too is insufficient.

  The \code{rtags} function is intended to be a tagging utility for R
  code.  It parses R code files (using R's parser) and produces tags in
  both \I{etags} and \I{ctags} formats.  The support for vi-style \I{ctags} is
  rudimentary, and was adapted from a patch by \I{Neal Fultz}; see
  \PR{17214}.

  It may be more convenient to use the command-line wrapper script
  \command{R CMD rtags}.
}

\references{
  \url{https://en.wikipedia.org/wiki/Ctags},
  \url{https://www.gnu.org/software/emacs/manual/html_node/emacs/Tags-Tables.html}
}
\author{Deepayan Sarkar}
\seealso{ \code{\link{list.files}}, \code{\link{cat}} }
\examples{

\dontrun{
rtags("/path/to/src/repository",
      pattern = "[.]*\\\\.[RrSs]$",
      keep.re = "/R/",
      verbose = TRUE,
      ofile = "TAGS",
      append = FALSE,
      recursive = TRUE)
}

}
\keyword{programming}
\keyword{utilities}

