% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_statistic.R
\name{get_statistic}
\alias{get_statistic}
\alias{get_statistic.default}
\alias{get_statistic.glmmTMB}
\alias{get_statistic.emmGrid}
\alias{get_statistic.gee}
\title{Get statistic associated with estimates}
\usage{
get_statistic(x, ...)

\method{get_statistic}{default}(x, column_index = 3, verbose = TRUE, ...)

\method{get_statistic}{glmmTMB}(x, component = "all", ...)

\method{get_statistic}{emmGrid}(x, ci = 0.95, adjust = "none", merge_parameters = FALSE, ...)

\method{get_statistic}{gee}(x, robust = FALSE, ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Currently not used.}

\item{column_index}{For model objects that have no defined
\code{get_statistic()} method yet, the default method is called. This
method tries to extract the statistic column from \code{coef(summary())},
where the index of the column that is being pulled is \code{column_index}.
Defaults to 3, which is the default statistic column for most models'
summary-output.}

\item{verbose}{Toggle warnings.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).
Currently only applies to objects of class \code{emmGrid}.}

\item{adjust}{Character value naming the method used to adjust p-values or
confidence intervals. See \code{?emmeans::summary.emmGrid} for details.}

\item{merge_parameters}{Logical, if \code{TRUE} and \code{x} has multiple columns for
parameter names (like \code{emmGrid} objects may have), these are merged into a
single parameter column, with parameters names and values as values.}

\item{robust}{Logical, if \code{TRUE}, test statistic based on robust
standard errors is returned.}
}
\value{
A data frame with the model's parameter names and the related test
statistic.
}
\description{
Returns the statistic (\emph{t}, \code{z}, ...) for model
estimates. In most cases, this is the related column from
\code{coef(summary())}.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"nonlinear"}: for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), returns staring estimates for the nonlinear parameters.
\item \code{"correlation"}: for models with correlation-component, like \code{gls}, the
variables used to describe the correlation structure are returned.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}

\strong{Special models}

Some model classes also allow rather uncommon options. These are:
\itemize{
\item \strong{mhurdle}: \code{"infrequent_purchase"}, \code{"ip"}, and \code{"auxiliary"}
\item \strong{BGGM}: \code{"correlation"} and \code{"intercept"}
\item \strong{BFBayesFactor}, \strong{glmx}: \code{"extra"}
\item \strong{averaging}:\code{"conditional"} and \code{"full"}
\item \strong{mjoint}: \code{"survival"}
\item \strong{mfx}: \code{"precision"}, \code{"marginal"}
\item \strong{betareg}, \strong{DirichletRegModel}: \code{"precision"}
\item \strong{mvord}: \code{"thresholds"} and \code{"correlation"}
\item \strong{clm2}: \code{"scale"}
\item \strong{selection}: \code{"selection"}, \code{"outcome"}, and \code{"auxiliary"}
\item \strong{lcmm}: \code{"membership"}, \code{"longitudinal"}, \code{"beta"}, \code{"splines"}, and
\code{"linear"}
}

For models of class \code{brmsfit} (package \strong{brms}), even more options are
possible for the \code{component} argument, which are not all documented in detail
here. It can be any pre-defined or arbitrary distributional parameter, like
\code{mu}, \code{ndt}, \code{kappa}, etc.
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_statistic(m)
}
